---
layout:     post
title:      Git 代码回滚
subtitle:   回滚代码的正确姿势
date:       2017-02-16
author:     BY
header-img: img/post-bg-debug.png
catalog: true
tags:
    - Mac
    - 终端
    - Git
---


>并不适合阅读的个人文档。

# **git revert** 和 **git reset** 的区别
 先看图：
 
![](https://ww3.sinaimg.cn/large/006tNbRwgy1fcr9tu6vdjj30t30ez0y8.jpg)

**sourceTree** 中 **revert** 译为**`提交回滚`**，作用为忽略你指定的版本，然后提交一个新的版本。新的版本中已近删除了你所指定的版本。

**reset** 为 **重置到这次提交**，将内容重置到指定的版本。`git reset` 命令后面是需要加2种参数的：`–-hard` 和 `–-soft`。这条命令默认情况下是 `-–soft`。

执行上述命令时，这该条commit号之 后（时间作为参考点）的所有commit的修改都会退回到git缓冲区中。使用`git status` 命令可以在缓冲区中看到这些修改。而如果加上`-–hard`参数，则缓冲区中不会存储这些修改，git会直接丢弃这部分内容。可以使用 `git push origin HEAD --force` 强制将分区内容推送到远程服务器。


#### 代码回退 

默认参数 `-soft`,所有commit的修改都会退回到git缓冲区
参数`--hard`，所有commit的修改直接丢弃

	$ git reset --hard HEAD^ 		回退到上个版本
	$ git reset --hard commit_id	退到/进到 指定commit_id
推送到远程	

	$ git push origin HEAD --force
	
	
#### 可以吃的后悔药->版本穿梭

当你回滚之后，又后悔了，想恢复到新的版本怎么办？

用`git reflog`打印你记录你的每一次操作记录

	$ git reflog
	
	输出：
	c7edbfe HEAD@{0}: reset: moving to c7edbfefab1bdbef6cb60d2a7bb97aa80f022687
	470e9c2 HEAD@{1}: reset: moving to 470e9c2
	b45959e HEAD@{2}: revert: Revert "add img"
	470e9c2 HEAD@{3}: reset: moving to 470e9c2
	2c26183 HEAD@{4}: reset: moving to 2c26183
	0f67bb7 HEAD@{5}: revert: Revert "add img"
	
找到你操作的id如：`b45959e`，就可以回退到这个版本
	
	$ git reset --hard b45959e
	


